#define VER     "3.0 (gl2.1)"
#define KEY	0x0000DEAD   // Default KEY used by DAEMON
#define GLGROUP "/glftpd/etc/group"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <syslog.h>
#include <unistd.h>
#include <sys/param.h>
#include <fcntl.h>
#include <sys/stat.h>

struct ONLINE {
  char   tagline[64];             /* The users tagline */
  char   username[24];            /* The username of the user */
  char   status[256];             /* The status of the user, idle, RETR, etc */
  short int ssl_flag;             /* 0 = no ssl, 1 = ssl on control, 2 = ssl on control and data */
  char   host[256];               /* The host the user is comming from (with ident) */
  char   currentdir[256];         /* The users current dir (fullpath) */
  long   groupid;                 /* The groupid of the users primary group */
  time_t login_time;              /* The login time since the epoch (man 2 time) */
  struct timeval tstart;          /* replacement for last_update. */
  struct timeval txfer;           /* The time of the last succesfull transfer. */
  unsigned long long bytes_xfer;  /* bytes transferred so far. */
  unsigned long long bytes_txfer; /* bytes transferred in the last loop (speed limiting) */
  pid_t  procid;                  /* The processor id of the process */
};

static struct ONLINE *online;
static int  dl = 0;
static int  ul = 0;
static int  num_users = 0;
static int  shmid;
static struct shmid_ds ipcbuf;

static void quit();
static double calc_time();

struct GROUP {
	char		*name;
	gid_t		id;
};

int	groups = 0,
	GROUPS = 0;

static struct GROUP	**group;
struct stat		 filestat;

char* get_g_name(int gid) {
 int	n;

 for ( n = 0 ; n < groups ; n++ ) if ( group[n]->id == gid ) return group[n]->name;
 return "NoGroup";
}

static char *
trim( char *str )
{
  char *ibuf;
  char *obuf;

  if ( str )
    {
      for ( ibuf = obuf = str; *ibuf; )
        {
          while ( *ibuf && ( isspace ( *ibuf ) ) )
          ibuf++;
          if ( *ibuf && ( obuf != str ) )
            *( obuf++ ) = ' ';
          while ( *ibuf && ( !isspace ( *ibuf ) ) )
            *( obuf++ ) = *( ibuf++ );
        }
      *obuf = '\0';
    }
  return( str );
}
				 
static char hmsbuf[50];			
void
pid_hms_format( time_t testtime )
{
  time_t timenow = time( NULL );
  time_t difftime;
  int    days = 0;
  int    hours = 0;
  int    minutes = 0;
  int    seconds = 0;

  difftime = timenow - testtime;
   
  while ( difftime >= (time_t)3600 )
    {
      difftime -= (time_t)3600;
      hours++;
    }          
   
  while ( difftime >= (time_t)60 )
    {
      difftime -= (time_t)60;
      minutes++;
    }
   
  if ( hours != 0 )
    sprintf( hmsbuf, "%02d:%02d:%02d", hours, minutes, difftime );
  else
    sprintf( hmsbuf, "   %02d:%02d", minutes, difftime );
}

static int
checkusers(void)
{
  register int i, j, found = 0;
  char statbuf[ 500 ];
  char idletime[ 500 ];
  char pidbuf[ 10 ];
  char filename[20];
  char bar[20];
  struct timeval tstop;
  unsigned	hours;
  unsigned  char minutes;
  unsigned	seconds;
	
  gettimeofday(&tstop, (struct timezone *)0);
		
  for (i=0; i<num_users; i++) 
    {
      if (online[i].procid == 0)
        continue;
      sprintf( pidbuf, "%u", online[i].procid );
      pid_hms_format( online[i].tstart.tv_sec );  
		
      if ((!strncasecmp (online[i].status, "STOR", 4) ||
	  !strncasecmp (online[i].status, "APPE", 4)) &&
          online[i].bytes_xfer != 0) {
          strncpy(filename, online[i].status+5, sizeof(filename));
          j = strlen(filename);
          if (!isprint(filename[j-2]))
            filename[j-2] = '\0';
          else if (!isprint(filename[j-1]))
            filename[j-1] = '\0';
          sprintf( statbuf, "Up:^%.1f", calc_time(i) );
          sprintf( idletime, "", hmsbuf );
          ul++;
        }
      /* Downloading */
      else if (!strncasecmp (online[i].status, "RETR", 4) && online[i].bytes_xfer != 0)
        {
          strncpy(filename, online[i].status+5, sizeof(filename));
          j = strlen(filename);
          if (!isprint(filename[j-2]))
            filename[j-2] = '\0';
          else if (!isprint(filename[j-1]))
            filename[j-1] = '\0';

          sprintf( statbuf, "Dn:^%.1f", calc_time(i) );
          sprintf( idletime, "", hmsbuf );
          dl++;
        }
      /* Idling */
      else if (time(NULL) - online[i].tstart.tv_sec > 5)
        {
	    *bar = *filename = hours = minutes = 0;
	    seconds = tstop.tv_sec - online[i].tstart.tv_sec;
	    while ( seconds >= 3600 ) { hours++;   seconds -= 3600; }
	    while ( seconds >= 60 ) { minutes++; seconds -= 60; } 
	    sprintf( statbuf, "Idle:", hmsbuf );
	    sprintf( idletime, "%02d:%02d:%02d", hours, minutes, seconds);
        }
      /* Doing something else... */
      else
        {
          sprintf( statbuf, "\"%s\"", online[i].status );
          trim(statbuf);
          sprintf( idletime, "", hmsbuf );
        }
      pid_hms_format( online[i].login_time); 
      fprintf( stdout, "%-1.12s^%-1.5s^%-1.44s^%s^%s^%s\n", 
              online[i].username, pidbuf, statbuf, online[i].currentdir, get_g_name(online[i].groupid), idletime);
      found++;
    }
  return (found);
}

int
main( int argc, char **argv )
{
  int numusers;
 
  if (argc >= 2)
  {

  if (strstr(argv[1],"-v") != NULL)
  { 
    printf ("Tur-FtpWho. A modified ftpwho by Turranius\n");
    printf ("Version %s - modified by f|lowman.\n",VER);
    quit (0);
  }  

  }

  buffer_groups(GLGROUP);

  if ((shmid = shmget( (key_t)KEY, 0, 0))
       == -1)
    {
      fprintf(stdout, "No Users Currently On Site!\n");
      exit(0);
    }

  if ((online = (struct ONLINE *)shmat( shmid, NULL, SHM_RDONLY))
      == (struct ONLINE *)-1)
    {
      fprintf(stdout, "Error: (SHMAT) Failed!\n");
      exit(1);
    }
							     
  shmctl( shmid, IPC_STAT, &ipcbuf);
  num_users = ipcbuf.shm_segsz / sizeof( struct ONLINE );

  numusers = checkusers();
   
  quit( 0 );
}

static double
calc_time(int pid)
{
  struct timeval tstop;
  double delta, rate;

  if (online[pid].bytes_xfer < 1)
    return 0;
  gettimeofday(&tstop, (struct timezone *)0 );
  delta = ((tstop.tv_sec*10.)+(tstop.tv_usec/100000.)) -
         ((online[pid].tstart.tv_sec*10.)+(online[pid].tstart.tv_usec/100000.));
  delta = delta/10.;
  rate = ((online[pid].bytes_xfer / 1024.0) / (delta));
  if (!rate) rate++;
  return (double)(rate);
}

static void
quit(int exit_status)
{
  shmctl( shmid, IPC_STAT, &ipcbuf);
  if (ipcbuf.shm_nattch <= 1) {
    shmctl( shmid, IPC_RMID, 0);
  }
  shmdt(0);
  exit(exit_status);
}

/* Buffer groups file */
int buffer_groups(char *groupfile) {
 char	*f_buf,
	*g_name,
	*f_name;
 long	f, n, m,
	f_size,
	g_id,
	g_n_size,
	l_start = 0;

 f_name = malloc( strlen(groupfile) + 2 );
 sprintf( f_name, "%s", groupfile );

 f = open( f_name, O_NONBLOCK );
 fstat( f, &filestat );
 f_size = filestat.st_size;
 f_buf  = malloc( f_size );
 read( f, f_buf, f_size );

 for ( n = 0 ; n < f_size ; n++ ) if ( f_buf[n] == '\n' ) GROUPS++;
 group = malloc( GROUPS * sizeof( int ) );

 for ( n = 0 ; n < f_size ; n++ ) {
  if ( f_buf[n] == '\n' || n == f_size ) {
   f_buf[n] = 0;
   m        = l_start;
   while ( f_buf[m] != ':' && m < n ) m++;
   if ( m != l_start ) {
    f_buf[m] = 0;
    g_name   = f_buf + l_start;
    g_n_size = m - l_start;
    m        = n;
    while ( f_buf[m] != ':' && m > l_start ) m--;
    f_buf[m] = 0;
    while ( f_buf[m] != ':' && m > l_start ) m--;
    if ( m != n ) {
     g_id = atoi( f_buf + m + 1 );
     group[groups] = malloc( sizeof( struct GROUP ) );
     group[groups]->name = malloc( g_n_size + 1 );
     strcpy( group[groups]->name, g_name );
     group[groups]->id = g_id;
     groups++;
    }
   }
   l_start = n + 1;
  }
 }
 
 close( f );
 free( f_buf );
 free( f_name );
}
